#ifdef TEXTURE
varying vec2 f_texcoord;
uniform sampler2D texture;
#endif

#ifdef COLOR
uniform vec3 color;
#endif

#ifdef FOG
varying float f_fogFactor;
#endif

void main(void)
{
	vec4 colorResult = vec4(0.0, 0.0, 0.0, 1.0);

#ifdef TEXTURE
	colorResult = texture2D(texture, f_texcoord);
	if(colorResult.a < 0.1)
		discard;
#endif

#ifdef COLOR
	colorResult = vec4(color, 1.0);
#endif

#ifdef FOG
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR, f_fogFactor);
#endif

	gl_FragColor = colorResult;
}
